import sys
def solve():

    try:
        n_line = sys.stdin.readline()
        if not n_line:
            n = 0
        else:
            n = int(n_line.strip())
    except Exception:
        return

    vectors = []
    for i in range(1, n + 1):
        try:
            line = sys.stdin.readline()
            if not line:
                break
            x, y = map(int, line.split())
            vectors.append({'x': x, 'y': y, 'index': i})
        except EOFError:
            break
        except ValueError:
            continue
            
    if n == 0:
        print(0)
        return

    max_dist_sq = -1
    best_indices = []
    directions = [
        ('y', lambda v: v['y'] > 0),  
        ('x', lambda v: v['x'] > 0),  
        ('x', lambda v: v['x'] < 0), 
        ('y', lambda v: v['y'] < 0)   
    ]

    for direction_name, criterion in directions:
        current_x = 0
        current_y = 0
        current_indices = []

        for vector in vectors:
            if criterion(vector):
                current_x += vector['x']
                current_y += vector['y']
                current_indices.append(vector['index'])

        dist_sq = current_x * current_x + current_y * current_y

        if dist_sq > max_dist_sq:
            max_dist_sq = dist_sq
            best_indices = current_indices


    print(len(best_indices))
    
    if best_indices:
        print(*(best_indices))


if __name__ == "__main__":
    solve()